package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;

@Data
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class CheckRequestPaymentRequest extends BalanceRpcRequestParam {

    @JsonProperty("ServiceID")
    private Integer serviceId;

    @JsonProperty("RequestID")
    private String requestId;

    @JsonProperty("TransactionID")
    private Option<String> transactionId = Option.empty();

    @JsonIgnore
    private Long operatorUid;

    public CheckRequestPaymentRequest withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public CheckRequestPaymentRequest withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public CheckRequestPaymentRequest withTransactionId(String transactionId) {
        this.transactionId = Option.of(transactionId);
        return this;
    }

    public CheckRequestPaymentRequest withTransactionIdO(Option<String> transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public CheckRequestPaymentRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[] { operatorUid.toString(), objectToMap(this) };
    }
}
