package ru.yandex.chemodan.balanceclient.model.request;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateInvoiceRequest extends BalanceRpcRequestParam {
    @JsonIgnore
    private Long operatorUid;

    @JsonProperty("RequestID")
    private String requestId;
    @JsonProperty("PaysysID")
    private String paySysId;
    @JsonProperty("PersonID")
    private String personId;
    @JsonProperty("ContractID")
    private String contractId;

    public CreateInvoiceRequest(Long uid, long requestId, String paySysId, long personId, long contractId) {
        this.requestId = String.valueOf(requestId);
        this.paySysId = paySysId;
        this.personId = String.valueOf(personId);
        this.contractId = String.valueOf(contractId);
        operatorUid = uid;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }
}
