package ru.yandex.chemodan.balanceclient.model.request;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateOfferRequest extends BalanceRpcRequestParam {
    public final static String PAYMENT_TYPE_PREPAY = "2";
    public final static String PAYMENT_TYPE_POSTPAID = "3";
    @JsonIgnore
    private Long operatorUid;

    @JsonProperty("client_id")
    private String clientId;
    @JsonProperty("person_id")
    private String personId;
    /**
     * создание лицевого счета
     */
    @JsonProperty("personal_account")
    private String personalAccount;
    @JsonProperty("manager_uid")
    private String managerUid;
    @JsonProperty("firm_id")
    private String firmId;
    @JsonProperty("currency")
    private String currency;
    @JsonProperty("services")
    private Set<Integer> services;
    @JsonProperty("country")
    private String country;
    @JsonProperty("payment_type")
    private String paymentType;
    /**
     * срок оплаты в днях возможные значения [5, 10, 11, 12, 13, 14, 15, 20, 25, 30, 32, 34, 35, 40,
     * 45, 50, 60, 75, 80, 90, 100, 120, 180]
     */
    @JsonProperty("payment_term")
    private String paymentTerm;

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }

    public CreateOfferRequest withOperatorUid(Long uid) {
        this.operatorUid = uid;
        return this;
    }

    public CreateOfferRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public CreateOfferRequest withPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public CreateOfferRequest withIsPersonalAccount(boolean isPersonalAccount) {
        this.personalAccount = isPersonalAccount ? "1" : null;
        return this;
    }

    public CreateOfferRequest withManagerUid(String managerUid) {
        this.managerUid = managerUid;
        return this;
    }

    public CreateOfferRequest withFirmId(String firmId) {
        this.firmId = firmId;
        return this;
    }

    public CreateOfferRequest withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public CreateOfferRequest withServices(Set<Integer> services) {
        this.services = services;
        return this;
    }

    public CreateOfferRequest withPaymentType(String paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    public CreateOfferRequest withCountry(String country) {
        this.country = country;
        return this;
    }

    public CreateOfferRequest withPaymentTerm(int days) {
        this.paymentTerm = Integer.toString(days);
        return this;
    }
}
