package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

/**
 * Запрос на создание плательщика
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createperson
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Getter
public class CreatePersonRequest extends BalanceRpcRequestParam {
    @JsonIgnore
    private Long operatorUid;

    // все поля строчки потому что балансу так нужно
    @JsonProperty("client_id")
    private String clientId;
    @JsonProperty("type")
    private String type;
    @JsonProperty("lname")
    private String lastName;
    @JsonProperty("fname")
    private String firstName;
    @JsonProperty("mname")
    private String middlename;
    @JsonProperty("phone")
    private String phone;
    @JsonProperty("email")
    private String email;

    @JsonProperty("postcode")
    private String postcode;
    @JsonProperty("postaddress")
    private String postAddress;

    @JsonProperty("legal_address_postcode")
    private String legalAddressPostcode;
    @JsonProperty("legaladdress")
    private String legalAddress;

    @JsonProperty("longname")
    private String longName;
    @JsonProperty("name")
    private String name;
    @JsonProperty("region")
    private String region;
    @JsonProperty("is_partner")
    private String isPartner; // 0 - платят нам, 1 - платим им
    @JsonProperty("inn")
    private String inn;
    @JsonProperty("kpp")
    private String kpp;

    public CreatePersonRequest withPostcode(String postcode) {
        this.postcode = postcode;
        return this;
    }

    public CreatePersonRequest withPostAddress(String postAddress) {
        this.postAddress = postAddress;
        return this;
    }

    public CreatePersonRequest withLegalAddress(String legalAddress) {
        this.legalAddress = legalAddress;
        return this;
    }

    public CreatePersonRequest withLegalAddressPostCode(String legalAddressPostcode) {
        this.legalAddressPostcode = legalAddressPostcode;
        return this;
    }

    public CreatePersonRequest withLongName(String longName) {
        this.longName = longName;
        return this;
    }

    public CreatePersonRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CreatePersonRequest withRegion(String region) {
        this.region = region;
        return this;
    }

    public CreatePersonRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public CreatePersonRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public CreatePersonRequest withType(String type) {
        this.type = type;
        return this;
    }

    public CreatePersonRequest withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public CreatePersonRequest withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public CreatePersonRequest withMiddlename(String middlename) {
        this.middlename = middlename;
        return this;
    }

    public CreatePersonRequest withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public CreatePersonRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    public CreatePersonRequest withIsPartner(boolean isPartner) {
        this.isPartner = isPartner ? "1" : "0";
        return this;
    }

    public CreatePersonRequest withInn(String inn) {
        this.inn = inn;
        return this;
    }

    public CreatePersonRequest withKpp(String kpp) {
        this.kpp = kpp;
        return this;
    }


    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }
}
