package ru.yandex.chemodan.balanceclient.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateRequest2Item {
    @JsonProperty("Qty")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal qty;
    @JsonProperty("ServiceID")
    private Integer serviceId;
    @JsonProperty("ServiceOrderID")
    private String serviceOrderId;

    public BigDecimal getQty() {
        return qty;
    }

    public CreateRequest2Item withQty(BigDecimal qty) {
        this.qty = qty;
        return this;
    }

    public Integer getServiceId() {
        return serviceId;
    }

    public CreateRequest2Item withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getServiceOrderId() {
        return serviceOrderId;
    }

    public CreateRequest2Item withServiceOrderId(String serviceOrderId) {
        this.serviceOrderId = serviceOrderId;
        return this;
    }

}
