package ru.yandex.chemodan.balanceclient.model.request;

import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Collections.emptyList;

/**
 * Запрос на создание "корзины"
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.createrequest2
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateRequest2Request extends BalanceRpcRequestParam {

    @JsonIgnore
    private List<CreateRequest2Item> items;

    @JsonIgnore
    private Long operatorUid;

    @JsonIgnore
    private Long clientId;

    @JsonProperty("ForceUnmoderated")
    private boolean forceUnmoderated;
    @JsonProperty("InvoiceDesireType")
    private String invoiceType;

    public Long getOperatorUid() {
        return operatorUid;
    }

    public List<CreateRequest2Item> getItems() {
        return items;
    }

    public CreateRequest2Request withItems(
            List<CreateRequest2Item> items)
    {
        this.items = items;
        return this;
    }

    public CreateRequest2Request withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public CreateRequest2Request withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public CreateRequest2Request withForceUnmoderated(boolean forceUnmoderated) {
        this.forceUnmoderated = forceUnmoderated;
        return this;
    }

    public CreateRequest2Request withInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), clientId.toString(),
                Optional.ofNullable(items).orElse(emptyList()).stream().map(this::objectToMap).toArray(),
                objectToMap(this)};
    }
}
