package ru.yandex.chemodan.balanceclient.model.request;


import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос в функцию Balance.FindClient
 * Сейчас используем не все доступные поля,
 * при необходимости более сложных запросов см. https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.findclient
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class FindClientRequest extends SelfMappedBalanceRpcRequest {
    @JsonProperty("PassportID")
    private String uid;

    @JsonProperty("AgencySelectPolicy")
    private Integer agencySelectPolicy;

    //Искать главных клиентов для тех, кто попадает под выборку
    @JsonProperty("PrimaryClients")
    private Integer primaryClients;

    public String getUid() {
        return uid;
    }

    public FindClientRequest withUid(Long uid) {
        this.uid = uid.toString();
        return this;
    }

    public Integer getAgencySelectPolicy() {
        return agencySelectPolicy;
    }

    public FindClientRequest withAgencySelectPolicy(AgencySelectPolicy agencySelectPolicy) {
        this.agencySelectPolicy = agencySelectPolicy.getPolicyIntegerValue();
        return this;
    }

    public Integer getPrimaryClients() {
        return primaryClients;
    }

    public FindClientRequest withPrimaryClients(Boolean findPrimaryClients) {
        this.primaryClients = findPrimaryClients ? 1 : 0;
        return this;
    }
}
