package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * Запрос для получения списка привязанных карт по пользователю и сервису.
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getboundpaymentmethods
 */
@Getter
@Setter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetBoundPaymentMethodsRequest extends BalanceRpcRequestParam {
    @JsonProperty("OperatorUID")
    private Long operatorUid;

    @JsonProperty("ServiceID")
    private Integer serviceID;

    public GetBoundPaymentMethodsRequest(Integer serviceID) {
        this.serviceID = serviceID;
    }

    public GetBoundPaymentMethodsRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), serviceID.toString()};
    }
}
