package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.balanceclient.JsonUtils;

/**
 * Запрос для получения формы привязки карты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getcardbindingurl
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetCardBindingURLRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private Long operatorUid;

    @JsonProperty("ServiceID")
    private Integer serviceID;

    @JsonProperty("Currency")
    private String currency;

    @JsonProperty("ReturnPath")
    private String returnPath;

    @JsonProperty("Payload")
    private String payload;

    @JsonIgnore
    private MapF<String, String> payloadMap = Cf.hashMap();

    public GetCardBindingURLRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public GetCardBindingURLRequest withServiceID(Integer serviceID) {
        this.serviceID = serviceID;
        return this;
    }

    public GetCardBindingURLRequest withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public GetCardBindingURLRequest withReturnPath(String returnPath) {
        this.returnPath = returnPath;
        return this;
    }

    public GetCardBindingURLRequest addToPayload(String name, Option<String> value) {
        value.ifPresent(v -> addToPayload(name, v));
        return this;
    }

    public GetCardBindingURLRequest addToPayload(String name, String value) {
        this.payloadMap.put(name, value);
        return this;
    }

    @Override
    public Object[] asArray() {
        if (payloadMap.isNotEmpty()) {
            payload = JsonUtils.toJson(payloadMap);
        }
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }


}
