package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * Запрос для получения списка актов
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getclientacts
 */
@Getter
@Setter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetClientActsRequest extends BalanceRpcRequestParam {
    @JsonProperty("ClientID")
    private String clientId;

    @JsonProperty("ContractID")
    private String contractId;

    @JsonIgnore
    private String serviceToken;

    public GetClientActsRequest(Long clientId) {
        this.clientId = clientId.toString();
    }

    public GetClientActsRequest withContractId(Long contractId) {
        this.contractId = contractId.toString();
        return this;
    }

    public GetClientActsRequest withServiceToken(String token) {
        this.serviceToken = token;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{serviceToken, objectToMap(this)};
    }
}
