package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;

/**
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getclientcontracts
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetClientContractsRequest extends BalanceRpcRequestParam {

    @JsonProperty("ClientID")
    private String clientId;
    @JsonProperty("ExternalID")
    private String externalId;
    @JsonProperty("PersonID")
    private String personId;
    @JsonProperty("Dt")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate stateOnDate;
    /**
     * Возможные значения 0 и 1, необязательный, по умолчанию 0. Добавляет оконченные договоры в выдачу.
     */
    @JsonProperty("AddFinished")
    private String addFinished;

    public GetClientContractsRequest withAddFinished(boolean addFinished) {
        this.addFinished = addFinished ? "1" : "0";
        return this;
    }

    public GetClientContractsRequest withClientId(Long clientId) {
        this.clientId = clientId.toString();
        return this;
    }

    public GetClientContractsRequest withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public GetClientContractsRequest withPersonId(Long personId) {
        this.personId = personId.toString();
        return this;
    }

    public GetClientContractsRequest withStateOnDate(LocalDate date) {
        this.stateOnDate = date;
        return this;
    }


    @Override
    public Object[] asArray() {
        return new Object[]{objectToMap(this)};
    }

    public String getClientId() {
        return clientId;
    }
}
