package ru.yandex.chemodan.balanceclient.model.request;

/**
 * Запрос для получения плательщиков клиента
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getclientpersons
 */
public class GetClientPersonsRequest extends BalanceRpcRequestParam {
    private String clientId;

    public GetClientPersonsRequest withClientId(Long clientId) {
        this.clientId = clientId.toString();
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{clientId};
    }
}
