package ru.yandex.chemodan.balanceclient.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.bolts.collection.ListF;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetPartnerBalanceRequest extends BalanceRpcRequestParam {

    private Integer serviceId;
    private ListF<String> contractIds;

    public GetPartnerBalanceRequest(Integer serviceId, ListF<Long> contractIds) {
        this.serviceId = serviceId;
        this.contractIds = contractIds.map(Objects::toString);
    }

    @Override
    public Object[] asArray() {
        return new Object[]{serviceId, contractIds.toArray()};
    }
}
