package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Метод возвращающий способы оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.getrequestchoices
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetRequestChoicesRequest extends BalanceRpcRequestParam {

    private static final int SKIP_TRUST_DEFAULT_VALUE = 1;

    @JsonProperty("OperatorUid")
    private String operatorUid;

    @JsonProperty("RequestID")
    private String requestID;

    @JsonProperty("ContractID")
    private String contractId;

    @JsonProperty("SkipTrust")
    private int skipTrust = SKIP_TRUST_DEFAULT_VALUE;

    public String getOperatorUid() {
        return operatorUid;
    }

    public GetRequestChoicesRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
        return this;
    }

    public String getRequestID() {
        return requestID;
    }

    public GetRequestChoicesRequest withRequestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    public GetRequestChoicesRequest withContractId(long contractId){
        this.contractId = String.valueOf(contractId);
        return this;
    }


    @Override
    public Object[] asArray() {
        return new Object[]{objectToMap(this),};
    }
}
