package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GetRequestPaymentMethodsRequest extends BalanceRpcRequestParam {

    @JsonProperty("OperatorUid")
    private String operatorUid;

    @JsonProperty("RequestID")
    private String requestId;

    @JsonProperty("ContractID")
    private Option<String> contractId = Option.empty();

    @JsonProperty("PersonID")
    private Option<String> personId = Option.empty();

    public GetRequestPaymentMethodsRequest withOperatorUid(PassportUid uid) {
        this.operatorUid = uid.toString();
        return this;
    }

    public GetRequestPaymentMethodsRequest withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public GetRequestPaymentMethodsRequest withContractId(String contractId) {
        this.contractId = Option.of(contractId);
        return this;
    }

    public GetRequestPaymentMethodsRequest withPersonId(String personId) {
        this.personId = Option.of(personId);
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[] { objectToMap(this) };
    }
}
