package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Запрос для получения плательщиков клиента
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.listclientpassports
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListClientPassportsRequest extends BalanceRpcRequestParam {

    private String clientId;
    private String operatorUid = "0";

    public ListClientPassportsRequest withClientId(Long clientId) {
        this.clientId = clientId.toString();
        return this;
    }

    public ListClientPassportsRequest withOperatorUid(long operatorUid) {
        this.operatorUid = String.valueOf(operatorUid);
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, clientId};
    }
}
