package ru.yandex.chemodan.balanceclient.model.request;

/**
 * Запрос для удаления представителя клиента
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.removeuserclientassociation
 */

public class RemoveUserClientAssociationRequest extends BalanceRpcRequestParam {
    private Long operatorUid;
    private Long clientId;
    private Long representativeUid;

    public Long getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
    }

    public RemoveUserClientAssociationRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public RemoveUserClientAssociationRequest withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getRepresentativeUid() {
        return representativeUid;
    }

    public void setRepresentativeUid(Long representativeUid) {
        this.representativeUid = representativeUid;
    }

    public RemoveUserClientAssociationRequest withRepresentativeUid(Long representativeUid) {
        this.representativeUid = representativeUid;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), clientId.toString(), representativeUid.toString()};
    }
}
