package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import ru.yandex.bolts.collection.Option;

@ToString
public class CheckBindingResponse {
    @JsonIgnore
    public static final String SUCCESS_BINDING_STATUS = "success";

    @JsonIgnore
    public static final String ERROR_STATUS = "error";

    @JsonIgnore
    public static final String IN_PROGRESS_BINDING_STATUS = "in_progress";

    @JsonProperty("binding_result")
    private String bindingResult;

    @JsonProperty("payment_method_id")
    private String paymentMethodId;

    @JsonProperty("payment_resp_desc")
    private String paymentResponseDescription;

    public String getBindingResult() {
        return bindingResult;
    }

    public Option<String> getPaymentMethodId() {
        return Option.ofNullable(paymentMethodId).filterNot(String::isEmpty);
    }

    public Option<String> getPaymentResponseDescription() {
        return Option.ofNullable(paymentResponseDescription).filterNot(String::isEmpty);
    }

    public CheckBindingResponse withBindingResult(String bindingResult) {
        this.bindingResult = bindingResult;
        return this;
    }

    public CheckBindingResponse withPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }


}
