package ru.yandex.chemodan.balanceclient.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.balanceclient.JsonUtils;

/**
 * Проверка состояния оплаты по реквесту
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.checkrequestpayment
 */
@Data
@NoArgsConstructor
@ToString
public class CheckRequestPaymentResponse {
    @JsonIgnore
    public static final String SUCCESS_PAYMENT_STATUS = "success";

    @JsonIgnore
    public static final String ERROR_NOT_ENOUGH_FUNDS = "not_enough_funds";
    @JsonIgnore
    public static final String LIMIT_EXCEEDED = "limit_exceeded";
    @JsonIgnore
    public static final SetF<String> NO_MONEY_ERRORS = Cf.set(ERROR_NOT_ENOUGH_FUNDS, LIMIT_EXCEEDED);

    @JsonProperty("request_id")
    protected String requestId;

    @JsonProperty("invoice_id")
    private String invoiceId;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("purchase_token")
    private String purchaseToken;

    @JsonProperty("transaction_id")
    private String transactionId;

    @JsonProperty("payload")
    private String payload;

    @JsonProperty("resp_code")
    // https://wiki.yandex-team.ru/Trust/Payments/RC/
    private String responseCode;

    @JsonProperty("resp_desc")
    private String responseDescription;

    @JsonProperty("payment_dt")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = JsonUtils.DATETIME_PATTERN)
    private Instant paymentDatetime;

    @JsonProperty("cancel_dt")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = JsonUtils.DATETIME_PATTERN)
    private Instant cancelDatetime;

    @JsonProperty("postauth_dt")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = JsonUtils.DATETIME_PATTERN)
    private Instant postauthDatetime;
}
