package ru.yandex.chemodan.balanceclient.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

/**
 * Ответ ручки получения списка актов
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getclientacts
 */
@Getter
@Setter
@SuppressWarnings("unused")
@ToString
public class ClientActInfo {
    @JsonProperty("DT")
    private Long dt;
    @JsonProperty("AMOUNT")
    private BigDecimal amount;
    @JsonProperty("PAID_AMOUNT")
    private BigDecimal paidAmount;
    @JsonProperty("EXTERNAL_ID")
    private String externalId;
    @JsonProperty("AMOUNT_NDS")
    private String amountNds;
    @JsonProperty("CONTRACT_ID")
    private Long contractId;
    @JsonProperty("AMOUNT_NSP")
    private String amountNsp;
    @JsonProperty("ID")
    private String id;
    @JsonProperty("PAYMENT_TERM_DT")
    private Long paymentTermDt;
    @JsonProperty("ROWS")
    private ListF<Row> rows;
    @JsonProperty("BAD_DEBTS")
    private ListF<BadDebt> badDebts = Cf.list();

    @Getter
    @Setter
    @ToString
    public static class Row {
        @JsonProperty("PAID_AMOUNT")
        private String paidAmount;
        @JsonProperty("AMOUNT")
        private String amount;
        @JsonProperty("QTY")
        private String qty;
        @JsonProperty("AMOUNT_NDS")
        private String amountNds;
        @JsonProperty("AMOUNT_NSP")
        private String amountNsp;
        @JsonProperty("PRODUCT_ID")
        private Integer productId;
    }

    public Instant getDt() {
        return new Instant(dt);
    }

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    @ToString
    public static class BadDebt {
        @JsonProperty("YANDEX_FAULT")
        private Boolean yandexFault;
        @JsonProperty("COMMENTARY")
        private String comment;
    }
}

