package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
public class ClientPassportInfo {
    @JsonProperty("Uid")
    private Long uid;
    @JsonProperty("Login")
    private String login;
    @JsonProperty("Name")
    private String name;
    @JsonProperty("ClientId")
    private Long clientId;
    @JsonProperty("IsMain")
    private Integer isMain;

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public ClientPassportInfo withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public ClientPassportInfo withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClientPassportInfo withName(String name) {
        this.name = name;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public ClientPassportInfo withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Integer getIsMain() {
        return isMain;
    }

    public void setIsMain(Integer isMain) {
        this.isMain = isMain;
    }

    public ClientPassportInfo withIsMain(Integer isMain) {
        this.isMain = isMain;
        return this;
    }
}
