package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

/**
 * Список возможных наборов: контракт
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#vozvrashhaemyeznachenija57
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
public class Contract {
    @JsonProperty("id")
    private Long id;
    @JsonProperty("person_id")
    private Long personId;
    @JsonProperty("client_id")
    private Long clientId;
    @JsonProperty("external_id")
    private String externalId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }
}
