package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
public class CreateOfferResponse {
    @JsonProperty("ID")
    private Long id;
    @JsonProperty("EXTERNAL_ID")
    private String externalId;

    public Long getId() {
        return id;
    }

    public CreateOfferResponse withId(Long id) {
        this.id = id;
        return this;
    }

    public String getExternalId() {
        return externalId;
    }

    public CreateOfferResponse withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }
}
