package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetBoundPaymentMethodsResponse {
    @JsonProperty("payment_method")
    private String paymentMethod;

    @JsonProperty("id")
    private String paymentMethodId;

    @JsonProperty("currency")
    private String currency;

    @ToString.Exclude
    @JsonProperty("account")
    private String account;

    @ToString.Exclude
    @JsonProperty("holder")
    private String holder;

    @ToString.Exclude
    @JsonProperty("expiration_year")
    private String expirationYear;

    @ToString.Exclude
    @JsonProperty("expiration_month")
    private String expirationMonth;

    @ToString.Exclude
    @JsonProperty("payment_system")
    private String paymentSystem;

    @JsonProperty("expired")
    private boolean expired;
}

