package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

/**
 * Хранит ссылку на форму для привязки карты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getcardbindingurl
 */
@ToString
public class GetCardBindingURLResponse {

    @JsonProperty("binding_url")
    private String bindingUrl;

    @JsonProperty("purchase_token")
    private String purchaseToken;

    public String getBindingUrl() {
        return bindingUrl;
    }

    public String getPurchaseToken() {
        return purchaseToken;
    }

    public GetCardBindingURLResponse withBindingUrl(String bindingUrl) {
        this.bindingUrl = bindingUrl;
        return this;
    }

    public GetCardBindingURLResponse withPurchaseToken(String purchaseToken) {
        this.purchaseToken = purchaseToken;
        return this;
    }
}
