package ru.yandex.chemodan.balanceclient.model.response;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.joda.time.LocalDate;

@Getter
@Setter
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class GetClientContractsResponseItem {
    @JsonProperty("ID")
    private Long id;
    @JsonProperty("EXTERNAL_ID")
    private String externalId;
    @JsonProperty("PERSON_ID")
    private Long personId;
    @JsonProperty("IS_ACTIVE")
    private Integer isActive;
    @JsonProperty("SERVICES")
    private Set<Integer> services;
    @JsonProperty("CURRENCY")
    private String currency;

    @JsonProperty("DT")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    @JsonProperty("FINISH_DT")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate finishDate;
    @JsonProperty("PAYMENT_TYPE")
    private String paymentType;

    public boolean isActive() {
        return Objects.equals(1, isActive);
    }

    @VisibleForTesting
    public static GetClientContractsResponseItem buildActiveBalanceContract() {
        GetClientContractsResponseItem contractsResponseItem = new GetClientContractsResponseItem();
        contractsResponseItem.setIsActive(1);
        return contractsResponseItem;
    }

    public GetClientContractsResponseItem withPersonId(long personId) {
        setPersonId(personId);
        return this;
    }
}
