package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * Хранит информацию о плательщике
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getclientpersons
 */
@Getter
@Setter
@ToString
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetClientPersonsResponseItem {

    public static final String LEGAL_PERSON_TYPE = "ur";
    public static final String NATURAL_PERSON_TYPE = "ph";

    @JsonProperty("ID")
    private Long id;
    @JsonProperty("NAME")
    private String name;
    @JsonProperty("TYPE")
    private String type;
    @JsonProperty("HIDDEN")
    private Integer hidden;
    @JsonProperty("CLIENT_ID")
    private Long clientId;
    @JsonProperty("EMAIL")
    private String email;
    @JsonProperty("PHONE")
    private String phone;
    @JsonProperty("LEGALADDRESS")
    private String legalAddress;
    @JsonProperty("LEGAL_ADDRESS_POSTCODE")
    private String legalAddressPostcode;

    @JsonProperty("POSTADDRESS")
    private String postAddress;
    @JsonProperty("POSTCODE")
    private String postcode;

    @JsonProperty("LONGNAME")
    private String fullName;
    @JsonProperty("INN")
    private String inn;
    @JsonProperty("KPP")
    private String kpp;

    @JsonProperty("LNAME")
    private String lastName;
    @JsonProperty("FNAME")
    private String firstName;
    @JsonProperty("MNAME")
    private String middlename;

    public GetClientPersonsResponseItem withId(Long id) {
        this.id = id;
        return this;
    }
}
