package ru.yandex.chemodan.balanceclient.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

@Getter
@Setter
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
public class GetPartnerBalanceContractResponseItem {
    @JsonProperty("ContractID")
    private Long contractId;

    public GetPartnerBalanceContractResponseItem withContractId(Long contractId) {
        this.contractId = contractId;
        return this;
    }

    @JsonProperty("Currency")
    private String currencyCode;

    public GetPartnerBalanceContractResponseItem withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @JsonProperty("ReceiptSum")
    private BigDecimal clientPaymentsSum;

    public GetPartnerBalanceContractResponseItem withClientPaymentsSum(BigDecimal clientPaymentsSum) {
        this.clientPaymentsSum = clientPaymentsSum;
        return this;
    }

    /**
     * Сколько насчитали пользователю
     */
    @JsonProperty("ConsumeSum")
    private BigDecimal consumeSum;

    public GetPartnerBalanceContractResponseItem withConsumeSum(BigDecimal consumeSum) {
        this.consumeSum = consumeSum;
        return this;
    }

    /**
     * сколько выставили актов (акты выставляются в начале месяца)
     */
    @JsonProperty("ActSum")
    private BigDecimal actSum;

    public GetPartnerBalanceContractResponseItem withActSum(BigDecimal actSum) {
        this.actSum = actSum;
        return this;
    }

    @JsonProperty("DT")
    private Instant actualityDate;

    // дата самого раннего наступившего срока оплаты
    @JsonProperty("ExpiredDT")
    private Instant expiredDT;

    // дата последнего акта
    @JsonProperty("LastActDT")
    private Instant lastActDT;

    public GetPartnerBalanceContractResponseItem withLastActDT(Instant lastActDT) {
        this.lastActDT = lastActDT;
        return this;
    }

    public GetPartnerBalanceContractResponseItem withExpiredDT(Instant expiredDT) {
        this.expiredDT = expiredDT;
        return this;
    }

    // неоплаченная сумма всех просроченных актов
    @JsonProperty("ExpiredDebtAmount")
    private BigDecimal expiredDebtAmount;

    public GetPartnerBalanceContractResponseItem withExpiredDebtAmount(BigDecimal expiredDebtAmount) {
        this.expiredDebtAmount = expiredDebtAmount;
        return this;
    }

    // неоплаченная сумма по самому раннему акту
    @JsonProperty("FirstDebtAmount")
    private BigDecimal firstDebtAmount;

    public GetPartnerBalanceContractResponseItem withFirstDebtAmount(BigDecimal firstDebtAmount) {
        this.firstDebtAmount = firstDebtAmount;
        return this;
    }

    // дата, с которой самый ранний неоплаченный акт станет просроченным
    @JsonProperty("FirstDebtPaymentTermDT")
    private Instant firstDebtPaymentTermDT;

    public GetPartnerBalanceContractResponseItem withFirstDebtPaymentTermDT(Instant firstDebtPaymentTermDT) {
        this.firstDebtPaymentTermDT = firstDebtPaymentTermDT;
        return this;
    }

    public Option<Instant> getExpiredDT() {
        return Option.ofNullable(expiredDT);
    }

    public Option<BigDecimal> getExpiredDebtAmount() {
        return Option.ofNullable(expiredDebtAmount);
    }

    public Option<BigDecimal> getFirstDebtAmount() {
        return Option.ofNullable(firstDebtAmount);
    }

    public Option<Instant> getFirstDebtPaymentTermDT() {
        return Option.ofNullable(firstDebtPaymentTermDT);
    }

    public Option<Instant> getLastActDT() {
        return Option.ofNullable(lastActDT);
    }

    public GetPartnerBalanceContractResponseItem withDebt(BigDecimal debt, Instant deadline) {
        return this.withFirstDebtAmount(debt).withFirstDebtPaymentTermDT(deadline);
    }

    public GetPartnerBalanceContractResponseItem withNoDebt() {
        return withDebt(null, null).withExpiredDebt();
    }

    public GetPartnerBalanceContractResponseItem withExpiredDebt() {
        return this.withExpiredDT(this.firstDebtPaymentTermDT).withExpiredDebtAmount(this.firstDebtAmount);
    }

    public GetPartnerBalanceContractResponseItem withNoExpiredDebt() {
        return this.withExpiredDT(null).withExpiredDebtAmount(null);
    }
}
