package ru.yandex.chemodan.balanceclient.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

/**
 * Информация о способе оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#vozvrashhaemyeznachenija57
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
public class GetRequestChoicesResponse {
    @JsonProperty("pcp_list")
    private List<PersonPaymentMethodDetails> personPaymentMethodDetails;

    public List<PersonPaymentMethodDetails> getPersonPaymentMethodDetails() {
        return personPaymentMethodDetails;
    }

    public void setPersonPaymentMethodDetails(
            List<PersonPaymentMethodDetails> personPaymentMethodDetails) {
        this.personPaymentMethodDetails = personPaymentMethodDetails;
    }
}
