package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

/**
 * Хранит сслыку на форму траста для оплаты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.payrequest
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class PayRequestResponse {
    @JsonProperty("payment_url")
    private String paymentUrl;

    @JsonProperty("request_id")
    private String requestId;

    @JsonProperty("transaction_id")
    private String purchaseToken;

    public String getPaymentUrl() {
        return paymentUrl;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getPurchaseToken() {
        return purchaseToken;
    }

    public void setPurchaseToken(String purchaseToken) {
        this.purchaseToken = purchaseToken;
    }
}
