package ru.yandex.chemodan.balanceclient.model.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;

@Data
@NoArgsConstructor
@ToString
public class RequestPaymentMethod {

    @JsonProperty("person_id")
    private String personId;

    @JsonProperty("person_name")
    private String personName;

    @JsonProperty("contract_id")
    private Option<String> contractId;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("payment_method_type")
    private String paymentMethodType;

    @JsonProperty("payment_method_id")
    private Option<String> paymentMethodId;

    @JsonProperty("payment_method_info")
    private MapF<String, Object> paymentMethodInfo;

    @JsonProperty("region_id")
    private Integer regionId;

    @JsonProperty("resident")
    private Boolean resident;

    @JsonProperty("legalEntity")
    private Boolean legalEntity;
}
