package ru.yandex.chemodan.app.psbilling.core;

import java.io.Serializable;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.layout.PatternLayout;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.log.TskvLogPatternLayout;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.version.AppName;

public abstract class AbstractPsBillingMainSupport extends ChemodanMainSupport {
    public static final String REQUESTS_LOGGER_NAME = "requests";
    public static final String PG_REQUESTS_LOGGER_NAME = "r.y.ch.jdbc.q"; // match jdbc.queries-logger-name property

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(ChemodanCommonContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        PluginManager.addPackage("ru.yandex.chemodan.log.plugins");

        super.configureLogger();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO).name(REQUESTS_LOGGER_NAME)
                .layout(requestsLogLayout(applicationName(), Option.empty()))
                .postfix("-requests").buffSize(1024 * 1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.DEBUG).name(PG_REQUESTS_LOGGER_NAME)
                .layout(requestsLogLayout(applicationName(), Option.of("pg")))
                .postfix("-requests").buffSize(1024 * 1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO)
                .name("ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4Utils")
                .layout(requestsLogLayout(applicationName(), Option.empty()))
                .postfix("-requests").buffSize(1024 * 1024).build();
    }

    private static Layout<? extends Serializable> requestsLogLayout(AppName applicationName, Option<String> name) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-" + applicationName.appName() + "-requests-log"
                + "\tappname="+applicationName.appName()
                + "\thost=" + HostnameUtils.localHostname()
                + "\tclass=%c"
                + "\tname=" + name.getOrElse("%tskvX{name}")
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\tlevel=%level"
                + "\trequest_id=%rid"
                + TskvLogPatternLayout.logEnvironment()
                + "\tmessage=%tskvm%tskvex%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }
}
