package ru.yandex.chemodan.app.psbilling.core.admin;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingBalanceConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.UserServicesConfiguration;
import ru.yandex.chemodan.app.psbilling.core.dao.admin.InappMigrationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.CardDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupTrustPaymentRequestDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.users.UserInfoService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.trust.client.TrustClient;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@Configuration
@Import({
        UserServicesConfiguration.class,
        PsBillingBalanceConfiguration.class
})
public class AdminConfiguration {
    @Bean
    InappMigrationDao inappMigrationDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new InappMigrationDao(psBillingJdbcTemplate);
    }

    @Bean
    public InappMigrationService inappMigrationService(UserBillingService userBillingService,
                                                       UserProductManager userProductManager, TrustClient trustClient,
                                                       OrderDao orderDao,
                                                       InappMigrationDao inappMigrationDao,
                                                       UserInfoService userInfoService,
                                                       TaskScheduler taskScheduler,
                                                       UserServiceManager userServiceManager) {
        return new InappMigrationService(userBillingService, userProductManager, orderDao, inappMigrationDao,
                trustClient,
                userInfoService, taskScheduler, userServiceManager);
    }

    @Bean
    public SupplementService supplementService(JdbcTemplate3 jdbcTemplate, TaskScheduler taskScheduler) {
        return new SupplementService(jdbcTemplate, taskScheduler);
    }

    @Bean
    public CardBinderScript cardBinderScript(TrustClient trustClient,
                                             BalanceService balanceService,
                                             GroupTrustPaymentRequestDao groupTrustPaymentRequestDao,
                                             CardDao cardDao, JdbcTemplate3 jdbcTemplate) {
        return new CardBinderScript(trustClient, balanceService, groupTrustPaymentRequestDao, cardDao, jdbcTemplate);
    }
}
