package ru.yandex.chemodan.app.psbilling.core.admin;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.admin.task.InappMigrationTask;
import ru.yandex.chemodan.app.psbilling.core.admin.task.SupplementNonRusTask;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.OrderProcessorFacade;
import ru.yandex.chemodan.trust.client.TrustClient;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@Configuration
@Import({
        AdminConfiguration.class
})
public class AdminTaskConfiguration {

    @Bean
    public InappMigrationTask inappMigrationTask(InappMigrationService inappMigrationService) {
        return new InappMigrationTask(inappMigrationService);
    }

    @Bean
    public SupplementNonRusTask supplementNonRusTask(TrustClient trustClient, OrderProcessorFacade orderProcessorFacade,
                                                     JdbcTemplate3 jdbcTemplate) {
        return new SupplementNonRusTask(trustClient, orderProcessorFacade, jdbcTemplate);
    }
}
