package ru.yandex.chemodan.app.psbilling.core.admin;

import lombok.AllArgsConstructor;
import org.intellij.lang.annotations.Language;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple3;
import ru.yandex.chemodan.app.psbilling.core.admin.task.SupplementNonRusTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@AllArgsConstructor
public class SupplementService {
    private final JdbcTemplate3 jdbcTemplate;
    private final TaskScheduler taskScheduler;

    public void schedule(int count, boolean dryRun, boolean checkRegion, boolean checkBillingStatus) {
        ListF<Tuple3<PassportUid, Integer, String>> data = getData(count, checkRegion, checkBillingStatus);
        schedule(dryRun, data);
    }

    public void schedule(boolean dryRun, int trustServiceId, ListF<Tuple2<Long, String>> data) {
        schedule(dryRun, data.map(x -> Tuple3.tuple(PassportUid.cons(x._1), trustServiceId, x._2)));
    }

    public void schedule(boolean dryRun, ListF<Tuple3<PassportUid, Integer, String>> data) {
        for (Tuple3<PassportUid, Integer, String> row : data) {
            taskScheduler.schedule(new SupplementNonRusTask(row._1, row._2, row._3, dryRun));
        }
    }

    public ListF<Tuple3<PassportUid, Integer, String>> getData(int count, boolean checkRegion,
                                                               boolean checkBillingStatus) {
        @Language("SQL") String sql = "" +
                "select o.uid, o.trust_service_id, o.trust_order_id\n" +
                "from user_services us\n" +
                "         join user_products up on us.user_product_id = up.id\n" +
                "         join user_info ui on us.uid = ui.uid\n" +
                "         join orders o on us.id = o.user_service_id\n" +
                "         left join supplemented_users su on su.uid = o.uid " +
                "            and o.trust_order_id = su.trust_order_id\n" +
                "where up.billing_type = 'trust'\n" +
                "  and us.next_check_date < now() + interval '30 day'\n" +
                "  and us.target = 'enabled'\n" +
                (checkRegion ? "  and ui.region_id != '225'\n" : "") +
                (checkBillingStatus ? "  and us.billing_status = 'wait_auto_prolong'\n" : "") +
                "  and us.auto_prolong_enabled = true\n" +
                "  and su.uid is null\n" +
                "limit ?;";

        ListF<Tuple3<PassportUid, Integer, String>> data = jdbcTemplate.query(sql, (rs, rowNum) ->
                        Tuple3.tuple(PassportUid.cons(rs.getLong("uid")),
                                rs.getInt("trust_service_id"),
                                rs.getString("trust_order_id")),
                count);
        return data;
    }
}
