package ru.yandex.chemodan.app.psbilling.core.admin.task;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.admin.InappMigrationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class InappMigrationTask extends OnetimeTaskSupport<InappMigrationTask.Parameters> {
    private InappMigrationService inappMigrationService;

    public InappMigrationTask(InappMigrationService inappMigrationService) {
        super(Parameters.class);
        this.inappMigrationService = inappMigrationService;
    }

    public InappMigrationTask(UUID inappMigrationId) {
        super(new Parameters(inappMigrationId));
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) {
        inappMigrationService.subscribe(parameters.getMigrationId());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(60);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 2);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.MIGRATE_INAPP_SUBSCRIPTION;
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return InappMigrationTask.Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final UUID migrationId;

        public static class Converter implements
                ActiveUniqueIdentifierConverter<InappMigrationTask.Parameters, InappMigrationTask.Parameters> {
            @Override
            public Class<InappMigrationTask.Parameters> getActiveUniqueIdentifierClass() {
                return InappMigrationTask.Parameters.class;
            }

            @Override
            public InappMigrationTask.Parameters convert(InappMigrationTask.Parameters parameters) {
                return parameters;
            }
        }
    }
}
