package ru.yandex.chemodan.app.psbilling.core.balance;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;

import ru.yandex.chemodan.balanceclient.model.request.CreatePersonRequest;
import ru.yandex.chemodan.balanceclient.model.response.GetClientPersonsResponseItem;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

import static ru.yandex.chemodan.app.psbilling.core.balance.BalanceService.COUNTRY_RUSSIA;

@AllArgsConstructor
@Getter
public abstract class PaymentData extends DefaultObject {
    private static final Logger logger = LoggerFactory.getLogger(PaymentData.class);

    protected final String email;
    protected final String phone;
    protected final String countryCode;

    public CreatePersonRequest toCreatePersonRequest() {
        validateForPersonRequest();
        return buildCreatePersonRequest();
    }

    protected CreatePersonRequest buildCreatePersonRequest() {
        return new CreatePersonRequest()
                .withType(getType())
                .withEmail(email)
                .withPhone(phone);
    }

    protected void validateForPersonRequest() {
        MatcherAssert.assertThat(countryCode, CoreMatchers.equalTo(COUNTRY_RUSSIA.toString()));
    }

    public static PaymentData of(GetClientPersonsResponseItem response) {
        if (GetClientPersonsResponseItem.LEGAL_PERSON_TYPE.equals(response.getType())) {
            return new UrPaymentData(response);
        } else if(GetClientPersonsResponseItem.NATURAL_PERSON_TYPE.equals(response.getType())) {
            return new PhPaymentData(response);
        }

        logger.debug("Unknown person type for clientId={} personId={}", response.getClientId(), response.getId());
        return new PaymentDataWithUnknownType(response);
    }

    public abstract String getType();
}
