package ru.yandex.chemodan.app.psbilling.core.balance;

import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.balanceclient.model.request.CreatePersonRequest;
import ru.yandex.chemodan.balanceclient.model.response.GetClientPersonsResponseItem;

import static ru.yandex.chemodan.app.psbilling.core.balance.BalanceService.COUNTRY_RUSSIA;

/**
 * @author friendlyevil
 */
// Нельзя использовать в нашей логике
// Нужно только для успешного парсинга нестандартных плательщиков, созданных не нами
// Такие клиенты должны отсеиваться на стадии фильтрации
public class PaymentDataWithUnknownType extends PaymentData {
    private final String type;

    public PaymentDataWithUnknownType(String email, String phone, String countryCode, String type) {
        super(email, phone, countryCode);
        this.type = type;
    }

    public PaymentDataWithUnknownType(GetClientPersonsResponseItem response) {
        this(response.getEmail(), response.getPhone(), COUNTRY_RUSSIA.toString(), response.getType());
    }

    @Override
    protected CreatePersonRequest buildCreatePersonRequest() {
        throw new NotImplementedException();
    }

    @Override
    public String getType() {
        return type;
    }
}
