package ru.yandex.chemodan.app.psbilling.core.balance;

import lombok.Getter;

import ru.yandex.chemodan.balanceclient.model.request.CreatePersonRequest;
import ru.yandex.chemodan.balanceclient.model.response.GetClientPersonsResponseItem;

import static ru.yandex.chemodan.app.psbilling.core.balance.BalanceService.COUNTRY_RUSSIA;

/**
 * @author friendlyevil
 */
@Getter
public class PhPaymentData extends PaymentData {
    private final String lastName;
    private final String firstName;
    private final String middleName;

    public PhPaymentData(String email, String phone, String countryCode, String lastName, String firstName, String middleName) {
        super(email, phone, countryCode);
        this.lastName = lastName;
        this.firstName = firstName;
        this.middleName = middleName;
    }

    public PhPaymentData(GetClientPersonsResponseItem response) {
        this(response.getEmail(), response.getPhone(), COUNTRY_RUSSIA.toString(), response.getLastName(),
                response.getFirstName(), response.getMiddlename());
    }

    @Override
    protected CreatePersonRequest buildCreatePersonRequest() {
        return super.buildCreatePersonRequest()
                .withLastName(lastName)
                .withFirstName(firstName)
                .withMiddlename(middleName);
    }

    @Override
    public String getType() {
        return GetClientPersonsResponseItem.NATURAL_PERSON_TYPE;
    }
}
