package ru.yandex.chemodan.app.psbilling.core.balance;

import java.util.function.Function;

import lombok.Getter;

import ru.yandex.chemodan.balanceclient.model.request.CreatePersonRequest;
import ru.yandex.chemodan.balanceclient.model.response.GetClientPersonsResponseItem;

import static ru.yandex.chemodan.app.psbilling.core.balance.BalanceService.COUNTRY_RUSSIA;

@Getter
public class UrPaymentData extends PaymentData {
    private final String organizationName;
    private final String inn;
    private final String kpp;

    private final Address legalAddress;
    private final Address postAddress;

    public UrPaymentData(String email, String phone, String countryCode, String organizationName,
                         String inn, String kpp, Address legalAddress,
                         Address postAddress) {
        super(email, phone, countryCode);
        this.organizationName = organizationName;
        this.inn = inn;
        this.kpp = kpp;
        this.legalAddress = legalAddress;
        this.postAddress = postAddress;
    }

    public UrPaymentData(GetClientPersonsResponseItem response) {
        this(response.getEmail(), response.getPhone(), COUNTRY_RUSSIA.toString(), response.getName(),
                response.getInn(), response.getKpp(),
                new Address(response.getLegalAddressPostcode(), response.getLegalAddress()),
                new Address(response.getPostcode(), response.getPostAddress()));
    }

    @Override
    protected CreatePersonRequest buildCreatePersonRequest() {
        return super.buildCreatePersonRequest()
                .withName(organizationName)
                .withLongName(organizationName)
                .withLegalAddress(mapAddress(legalAddress, Address::getAddress))
                .withLegalAddressPostCode(mapAddress(legalAddress, Address::getPostcode))
                .withPostAddress(mapAddress(postAddress, Address::getAddress))
                .withPostcode(mapAddress(postAddress, Address::getPostcode))
                .withInn(inn)
                .withKpp(kpp);
    }

    private static String mapAddress(Address address, Function<Address, String> fun) {
        if (address == null) {
            return null;
        }
        return fun.apply(address);
    }

    @Override
    public String getType() {
        return GetClientPersonsResponseItem.LEGAL_PERSON_TYPE;
    }
}
