package ru.yandex.chemodan.app.psbilling.core.billing.groups;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.PaymentChecker;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class CheckPaymentRequestStatusTask extends OnetimeTaskSupport<CheckPaymentRequestStatusTask.Parameters> {
    private PaymentChecker paymentChecker;

    public CheckPaymentRequestStatusTask(PaymentChecker paymentChecker) {
        super(Parameters.class);
        this.paymentChecker = paymentChecker;
    }

    public CheckPaymentRequestStatusTask(Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) {
        paymentChecker.checkPaymentRequestStatus(parameters.getRequestId());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Data
    @BenderBindAllFields
    public static class Parameters {
        private final String requestId;
    }
}
