package ru.yandex.chemodan.app.psbilling.core.billing.groups;

import java.math.BigDecimal;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupStatus;
import ru.yandex.misc.lang.DefaultObject;

@Getter
public class GroupBillingStatus extends DefaultObject {
    private final GroupStatus status;
    private final MapF<Long, Money> contractRequiredPayments;
    private final MapF<Long, Money> contracts;
    private final Option<Instant> firstDebtPaymentDeadline;

    public GroupBillingStatus(GroupStatus status, MapF<Long, Money> contracts, Option<Instant> firstDebtPaymentDeadline) {
        this.status = status;
        this.contracts = contracts;
        this.firstDebtPaymentDeadline = firstDebtPaymentDeadline;
        this.contractRequiredPayments = contracts.filterValues(x -> x.getAmount().compareTo(BigDecimal.ZERO) > 0);
    }
}
