package ru.yandex.chemodan.app.psbilling.core.billing.groups;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GroupServiceTransactionsCalculationTask extends
        OnetimeTaskSupport<GroupServiceTransactionsCalculationTask.Parameters>
{

    private GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService;

    public GroupServiceTransactionsCalculationTask(LocalDate billingDate)
    {
        super(new Parameters(billingDate));
        this.groupServiceTransactionsCalculationService = null;
    }

    public GroupServiceTransactionsCalculationTask(
            GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService)
    {
        super(Parameters.class);
        this.groupServiceTransactionsCalculationService = groupServiceTransactionsCalculationService;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) {
        groupServiceTransactionsCalculationService.calculateGroupServicesTransactions(parameters.date);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1),
                Duration.standardDays(1).toStandardMinutes().getMinutes());
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }


    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final LocalDate date;

        public static class Converter implements
                ActiveUniqueIdentifierConverter<Parameters, Parameters>
        {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public GroupServiceTransactionsCalculationTask.Parameters convert(Parameters parameters) {
                return parameters;
            }
        }

    }
}
