package ru.yandex.chemodan.app.psbilling.core.billing.groups;


import java.math.BigDecimal;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.balanceclient.model.response.GetPartnerBalanceContractResponseItem;

@Data
public class InactiveClientBalanceInfo {

    private final BigDecimal incomeSum;
    private final BigDecimal actSum;
    private final Option<Instant> lastActDate;

    public static InactiveClientBalanceInfo byBalanceContract(GetPartnerBalanceContractResponseItem balance) {
        return new InactiveClientBalanceInfo(
                balance.getClientPaymentsSum(),
                balance.getActSum(),
                balance.getLastActDT()
        );
    }
    public InactiveClientBalanceInfo addBalanceInfo(GetPartnerBalanceContractResponseItem balance) {
        Option<Instant> newLastTransactionsDate = this.lastActDate
                .map(t1 -> balance.getLastActDT().map(t2 -> t1.isAfter(t2) ? t1 : t2).orElse(t1))
                .orElse(balance.getLastActDT());

        return new InactiveClientBalanceInfo(
                this.incomeSum.add(balance.getClientPaymentsSum()),
                this.actSum.add(balance.getActSum()),
                newLastTransactionsDate
        );
    }

    public BigDecimal getBalance() {
        return incomeSum
                .add(actSum.negate());
    }
}
