package ru.yandex.chemodan.app.psbilling.core.billing.groups;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

public class ManualRecalculationTask extends OnetimeTaskSupport<ManualRecalculationTask.Parameters> {

    private GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService;

    public ManualRecalculationTask(GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService) {
        super(Parameters.class);
        this.groupServiceTransactionsCalculationService = groupServiceTransactionsCalculationService;
    }

    public ManualRecalculationTask(LocalDate startDate, LocalDate endDate, boolean export)
    {
        super(new Parameters(startDate, endDate, export));
    }

    @Override
    protected void execute(ManualRecalculationTask.Parameters parameters, ExecutionContext context) throws Exception {
        groupServiceTransactionsCalculationService.recalculate(parameters.startDate, parameters.endDate,
                parameters.export);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1),
                Duration.standardDays(1).toStandardMinutes().getMinutes());
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }


    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return ManualRecalculationTask.Parameters.Converter.class;
    }


    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final LocalDate startDate;
        private final LocalDate endDate;
        private final boolean export;

        public static class Converter implements
                ActiveUniqueIdentifierConverter<ManualRecalculationTask.Parameters, Identifier>
        {
            @Override
            public Class<Identifier> getActiveUniqueIdentifierClass() {
                return Identifier.class;
            }

            @Override
            public Identifier convert(ManualRecalculationTask.Parameters parameters) {
                return Identifier.INSTANCE;
            }
        }
    }

    @BenderBindAllFields
    public static class Identifier extends DefaultObject {
        private static final Identifier INSTANCE = new Identifier();
    }


}
