package ru.yandex.chemodan.app.psbilling.core.billing.groups;

import java.math.BigDecimal;
import java.util.Currency;

import lombok.Value;

@Value
public class Money {
    BigDecimal amount;
    Currency currency;

    public String getCurrencyCode() {
        return currency.getCurrencyCode();
    }

    public Money(BigDecimal amount, Currency currency) {
        this.amount = amount;
        this.currency = currency;
    }

    public Money(BigDecimal amount, String currency) {
        this(amount, Currency.getInstance(currency));
    }

    public static Money rub(BigDecimal amount) {
        return new Money(amount, "RUB");
    }
    public static Money rub(double amount) {
        return rub(BigDecimal.valueOf(amount));
    }
}
