package ru.yandex.chemodan.app.psbilling.core.billing.groups.export;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function2;

public interface YtOperations<TExportRow extends YtExportRow> {
    boolean isEnabled();

    boolean isAlreadyExported();

    String createExportFolder();

    MapF<String, ListF<String>> findExportFolders();

    String getCurrentExport();

    void removeExportFolder(String path);

    ListF<String> findEmptyExportTables(String exportFolder);

    boolean isValidExport(String path);

    void overwriteTableInTransaction(String pathToTable,
                                     Function2<Option<UUID>, Integer, ListF<TExportRow>> dataProducer);

    void exportCompleted(String exportedFolder);

    Option<Instant> getCurrentExportInstant();
}
