package ru.yandex.chemodan.app.psbilling.core.billing.groups.export.distributionplatform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.BaseYtOperations;
import ru.yandex.chemodan.app.psbilling.core.config.YtExportSettings;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.DistributionPlatformTransactionsDao;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class YtOperationsDistributionPlatformTransactionsImpl
        extends BaseYtOperations<DistributionPlatformTransactionsDao.ExportRow>
        implements YtOperationsDistributionPlatformTransactions {
    private static final Logger logger =
            LoggerFactory.getLogger(YtOperationsDistributionPlatformTransactionsImpl.class);

    public YtOperationsDistributionPlatformTransactionsImpl(YtExportSettings settings,
                                                            Function0<Integer> batchSizeProvider) {
        super(settings, batchSizeProvider);
    }

    @Override
    protected JsonNode mapExportRow(DistributionPlatformTransactionsDao.ExportRow exportRow) {
        return JsonNodeFactory.instance.objectNode()
                .put("billing_period", DATE_FORMATTER.print(exportRow.getBillingPeriod()))
                .put("clid", exportRow.getClid())
                .put("count", exportRow.getCount().toString())
                .put("currency", exportRow.getCurrency())
                .put("money", exportRow.getMoney().toString())
                .put("product_id", exportRow.getProductId());
    }

    @Override
    protected YTreeNode buildTableAttributes() {
        return YTree.builder()
                .beginMap()
                .key("schema")
                .beginAttributes()
                .key("unique_keys").value(false)
                .key("strict").value(true)
                .endAttributes()
                .beginList()
                .apply(b -> addColumn(b, "billing_period", "string", true))
                .apply(b -> addColumn(b, "clid", "string", true))
                .apply(b -> addColumn(b, "count", "string", true))
                .apply(b -> addColumn(b, "currency", "string", true))
                .apply(b -> addColumn(b, "money", "string", true))
                .apply(b -> addColumn(b, "product_id", "string", true))
                .endList()
                .endMap()
                .build();
    }
}
