package ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices;

import javax.annotation.Nullable;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.EmptyParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleNever;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;

public class GroupServiceTransactionsExportTask extends OnetimeTaskSupport<EmptyParameters> {

    private GroupServiceTransactionsExportService groupServiceTransactionsExportService;

    public GroupServiceTransactionsExportTask()
    {
        super(new EmptyParameters());
        this.groupServiceTransactionsExportService = null;
    }

    public GroupServiceTransactionsExportTask(
            GroupServiceTransactionsExportService groupServiceTransactionsExportService)
    {
        super(EmptyParameters.class);
        this.groupServiceTransactionsExportService = groupServiceTransactionsExportService;
    }

    @Override
    protected void execute(EmptyParameters parameters, ExecutionContext context) throws Exception {
        groupServiceTransactionsExportService.export();
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleNever();
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(3);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Converter.class;
    }


    public static class Converter implements
            ActiveUniqueIdentifierConverter<EmptyParameters, EmptyParameters>
    {
        @Override
        public Class<EmptyParameters> getActiveUniqueIdentifierClass() {
            return EmptyParameters.class;
        }

        @Override
        public EmptyParameters convert(EmptyParameters parameters)
        {
            return parameters;
        }
    }
}
