package ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices;

import java.util.Objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.BaseYtOperations;
import ru.yandex.chemodan.app.psbilling.core.config.YtExportSettings;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceTransactionsDao;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class YtOperationsGroupTransactionsImpl
        extends BaseYtOperations<GroupServiceTransactionsDao.ExportRow>
        implements YtOperationsGroupTransactions {
    private final Integer serviceId;

    public YtOperationsGroupTransactionsImpl(YtExportSettings settings, Integer serviceId, Function0<Integer> batchSizeProvider) {
        super(settings, batchSizeProvider);
        this.serviceId = serviceId;
    }

    @Override
    protected YTreeNode buildTableAttributes() {
        return YTree.builder()
                .beginMap()
                .key("schema")
                .beginAttributes()
                .key("unique_keys").value(false)
                .key("strict").value(true)
                .endAttributes()
                .beginList()
                .apply(b -> addColumn(b, "service_order_id", "string", true))
                .apply(b -> addColumn(b, "dt", "string", true))
                .apply(b -> addColumn(b, "client_id", "string", true))
                .apply(b -> addColumn(b, "total_sum", "string", true))
                .apply(b -> addColumn(b, "transaction_currency", "string", true))
                .apply(b -> addColumn(b, "type", "string", true))
                .apply(b -> addColumn(b, "service_id", "string", true))
                .apply(b -> addColumn(b, "transaction_id", "string", false))
                .apply(b -> addColumn(b, "orig_transaction_id", "string", false))
                .apply(b -> addColumn(b, "payment_type", "string", false))
                .apply(b -> addColumn(b, "commission_sum", "string", false))
                .apply(b -> addColumn(b, "promocode_sum", "string", false))
                .apply(b -> addColumn(b, "use_discount", "string", false))
                .endList()
                .endMap()
                .build();
    }

    @Override
    protected JsonNode mapExportRow(GroupServiceTransactionsDao.ExportRow exportRow) {
        return JsonNodeFactory.instance.objectNode()
                .put("service_order_id", exportRow.getGroupServiceTransaction().getGroupServiceId().toString())
                .put("dt", DATE_FORMATTER.print(exportRow.getGroupServiceTransaction().getBillingDate()))
                .put("client_id", exportRow.getClientId())
                .put("total_sum", exportRow.getGroupServiceTransaction().getAmount().toString())
                .put("transaction_currency", exportRow.getGroupServiceTransaction().getCurrency().getCurrencyCode())
                .put("type", exportRow.getBalanceProductName())
                .put("service_id", Objects.toString(serviceId));
    }
}
